﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Users
{
    public partial class EditUsers : System.Web.UI.Page
    {
        private UserAccount currAccount;

        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                if (Request.QueryString["UniqueID"] != null)
                {
                    hdUserAccountID.Value = Request.QueryString["UniqueID"].ToString();
                    ShowUserDetails();
                }
            }
        }

        private void ShowUserDetails()
        {
            currAccount = UserAccountBL.GetItem(Guid.Parse(hdUserAccountID.Value.Trim()), string.Empty, string.Empty, string.Empty, DateTime.MinValue, DateTime.MinValue);
            if (currAccount != null)
            {
                hdUserAccountID.Value = currAccount.UniqueID.ToString();
                txtUserName.Text = currAccount.UserName;
                txtPassword.Attributes["value"] = ValidationUtility.DecryptPassword(currAccount.UPassword);
                ddlSalutation.SelectedIndex = ddlSalutation.Items.IndexOf(ddlSalutation.Items.FindByValue(currAccount.Salutation));
                txtFirstName.Text = currAccount.FirstName;
                txtLastName.Text = currAccount.LastName;
                ddlGender.SelectedIndex = ddlGender.Items.IndexOf(ddlGender.Items.FindByValue(currAccount.Gender));
                txtEmail.Text = currAccount.Email;
                txtMobileNo.Text = currAccount.MobileNo;
                txtPhoneNo.Text = currAccount.PhoneNo;
                txtDOB.Text = currAccount.DOB != DateTime.MinValue ? currAccount.DOB.ToString("dd/MM/yyyy") : string.Empty;
                txtOccupation.Text = currAccount.Occupation;
                ddlUserRoleType.SelectedIndex = ddlUserRoleType.Items.IndexOf(ddlUserRoleType.Items.FindByValue(currAccount.UserRoleType));
                chkIsActive.Checked = currAccount.IsActive;
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            string password = txtPassword.Text.Trim();
            if (ValidatePageValue())
            {
                currAccount = new UserAccount();
                if (hdUserAccountID.Value.Trim().Length == 0)
                    currAccount.Mode = GlobalConfigurations.Mode.Insert;
                else
                {
                    currAccount.Mode = GlobalConfigurations.Mode.Update;
                    currAccount.UniqueID = Guid.Parse(hdUserAccountID.Value.Trim());
                }

                currAccount.UserName = txtUserName.Text.Trim();
                currAccount.UPassword = ValidationUtility.EncryptPassword(txtPassword.Text.Trim());
                currAccount.Salutation = ddlSalutation.SelectedValue != "0" ? ddlSalutation.SelectedValue : string.Empty;
                currAccount.FirstName = txtFirstName.Text.Trim();
                currAccount.LastName = txtLastName.Text.Trim();
                currAccount.Gender = ddlGender.SelectedValue != "0" ? ddlGender.SelectedValue : string.Empty;
                currAccount.Email = txtEmail.Text.Trim();
                currAccount.MobileNo = txtMobileNo.Text.Trim();
                currAccount.PhoneNo = txtPhoneNo.Text.Trim();
                currAccount.DOB = txtDOB.Text.Trim().Length != 0 ? DateTime.ParseExact(txtDOB.Text.Trim(), "dd/MM/yyyy", null) : DateTime.MinValue;
                currAccount.Occupation = txtOccupation.Text.Trim();
                currAccount.UserRoleType = ddlUserRoleType.SelectedValue;
                currAccount.IsApproved = true;
                currAccount.IsActive = chkIsActive.Checked;
                currAccount.AdminUserAccountID = (WebSession.CurrentAdminUser != null ? WebSession.CurrentAdminUser.UniqueID : Guid.Empty);

                if (UserAccountBL.Save(currAccount))
                {
                    WebUtilities.OpenNewAddEditDialog(this, "Success", "User details has been saved successfully.<br>Do you want to add another User?", this.ResolveClientUrl("~/Admin/Users/Users.aspx"));
                }
            }
            else
            {
                txtPassword.Attributes["value"] = password;
            }
        }

        protected void btnCancel_Click(object sender, EventArgs e)
        {
            Response.Redirect("~/Admin/Users/Users.aspx", false);
        }

        private bool ValidatePageValue()
        {
            if (!ValidationUtility.ValidateString(txtUserName.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + txtUserName.ClientID + "', 'Please enter valid User Name.'); ", true);
                return false;
            }

            if (!ValidationUtility.ValidateString(txtPassword.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + txtPassword.ClientID + "', 'Please enter valid Password.'); ", true);
                return false;
            }

            //if (ddlSalutation.SelectedValue.Equals("0"))
            //{
            //    ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + ddlSalutation.ClientID + "', 'Please select Salutation.'); ", true);
            //    return false;
            //}

            if (!ValidationUtility.ValidateString(txtFirstName.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + txtFirstName.ClientID + "', 'Please enter valid First Name.'); ", true);
                return false;
            }

            if (!ValidationUtility.ValidateString(txtLastName.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + txtLastName.ClientID + "', 'Please enter valid Last Name.'); ", true);
                return false;
            }

            //if (ddlGender.SelectedValue.Equals("0"))
            //{
            //    ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + ddlGender.ClientID + "', 'Please select Gender.'); ", true);
            //    return false;
            //}

            if (!ValidationUtility.ValidateEmail(txtEmail.Text.Trim()))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + txtEmail.ClientID + "', 'Please enter valid Email.'); ", true);
                return false;
            }

            //if (!ValidationUtility.ValidateString(txtMobileNo.Text.Trim()))
            //{
            //    ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + txtMobileNo.ClientID + "', 'Please enter valid Mobile No.'); ", true);
            //    return false;
            //}

            //if (!ValidationUtility.ValidateString(txtPhoneNo.Text.Trim()))
            //{
            //    ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + txtPhoneNo.ClientID + "', 'Please enter valid PhoneNo.'); ", true);
            //    return false;
            //}

            if (ValidationUtility.ValidateString(txtDOB.Text.Trim()) && !ValidationUtility.ValidateDate(txtDOB.Text.Trim(), "dd/MM/yyyy"))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + txtDOB.ClientID + "', 'Please enter valid DOB.'); ", true);
                return false;
            }

            //if (!ValidationUtility.ValidateString(txtOccupation.Text.Trim()))
            //{
            //    ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + txtOccupation.ClientID + "', 'Please enter valid Occupation.'); ", true);
            //    return false;
            //}

            if (ddlUserRoleType.SelectedValue.Equals("0"))
            {
                ScriptManager.RegisterStartupScript(this, GetType(), "Ei8ht POS", "validationMsgBottom('#" + ddlUserRoleType.ClientID + "', 'Please select Role Type.'); ", true);
                return false;
            }

            return true;
        }
    }
}